<?php
// to show all errors
// error_reporting(E_ALL);
// ini_set('display_errors', '1');

// To hide all errors
error_reporting(0);
ini_set('display_errors', 0);


// Using database connection file here
include_once "../db_connection.php";


$uploadedFile = $statusMsg = $colour= $c='';
$msgClass = 'errordiv';


// Ensure the script only runs if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if both 'id' and 'personnelOnly' are set in the POST request
    if (isset($_POST['id']) && isset($_POST['FormType'])) {
        $PAN_ID = $_POST['id'];
        $personnelOnly = $_POST['FormType'];

        // Debugging: Print the received values
        // echo "Received PAN_ID: $PAN_ID<br>";
        // echo "Received personnelOnly: $personnelOnly<br>";

        // Check if the received values are empty
        if (empty($PAN_ID)) {
            echo "Error: PAN_ID is empty!";
            exit();
        }

        if (empty($personnelOnly)) {
            echo "Error: personnelOnly is empty!";
            exit();
        }

        // Prepare the SQL query
        $sql = "SELECT * FROM PAN_newhires WHERE PAN_ID = ?";
        $stmt = $conn->prepare($sql);

        // Check if the statement was prepared successfully
        if ($stmt) {
            // Bind the PAN_ID parameter to the SQL query
            $stmt->bind_param("i", $PAN_ID);

            // Execute the SQL query
            $stmt->execute();

            // Get the result of the query
            $result = $stmt->get_result();

            // Check if a row was found
            if ($data = $result->fetch_assoc()) {

              //header Info
              $fromName = $data['fromName'];  // From Name saved in DB
              // echo $fromName;
              $from = $data['from_email']; // From email from DB

              // Define the recipient and email subject
              // $to = 'saquib.patwa@selectransportation.com';

              // ===============================
              // Load branch/department email config
              // ===============================
              $emailConfig = include __DIR__ . '/../config.php';
              // Normalize case for lookup
                      $branch = strtoupper(trim($data['branch']));
                      $department = strtoupper(trim($data['department']));


                      if (!isset($emailConfig) || !is_array($emailConfig)) {
                          die("Email config not loaded or invalid.");
                      }

                      // Also normalize config keys
                      $normalizedConfig = [];
                      foreach ($emailConfig as $b => $departments) {
                          $bKey = strtoupper(trim($b));

                          if (!is_array($departments)) {
                              continue; // skip if it's not an array
                          }

                          foreach ($departments as $d => $email) {
                              $normalizedConfig[$bKey][strtoupper(trim($d))] = $email;
                          }
                      }


                      if (isset($normalizedConfig[$branch][$department])) {
                          $to = $normalizedConfig[$branch][$department];
                      } else {
                          $to = 'basspollution@yahoo.com'; // fallback
                      }





              // $subject = "PERSONNEL ACTION NOTICE - ";
              $subject = "PERSONNEL ACTION NOTICE - " . strtoupper ($data['first_name']) . " " . strtoupper ($data['last_name']);
              // $headers = "From: no-reply@selectransportation.com";

                // Process the data and prepare the email content
                $email_message = "";

                // Construct the email message as HTML
            $email_message = '<html><body>';
            $email_message .= '<table cellspacing="0" cellpadding="10" style="border:1px solid #000;width:100%;">';
            $email_message .= '<tr><td colspan="2" style="background-color: #000000; color: #FFFFFF; text-align: center;">PERSONNEL ACTION NOTICE</td></tr>';


                // Loop through the data to build the email message
                foreach ($data as $key => $value) {
                    // Only include non-empty values
                    if (!empty($value)) {
                        // $formatted_column = ucwords(str_replace('_', ' ', $column));
                        // $email_message .= $formatted_column . ": " . $value . "\n";

                        $email_message .= '<tr>';
                    $email_message .= '<td style="background-color:#EFEFEF;">' . ucfirst(str_replace('_', ' ', $key)) . '</td>';
                    $email_message .= '<td>' . $value . '</td>';
                    $email_message .= '</tr>';
                    }
                }

                // // Add the approval link to the email message
                // $message .= '<div style="text-align:center;">
                //     <a href="http://webdev.str.com/wordpress/helpdesk/approval.php?PAN_ID=' . base64_encode($PAN_ID) . '&personnelOnly=' . base64_encode($personnelOnly) . '" style="color: #FFFFFF; background-color: #1F7F4C; padding: 10px; border-radius: 5px; text-decoration: none;">APPROVE/REJECT</a></div>';







                $personnelNoticeList = array(
                    'PAN_ID'           => $data['PAN_ID'],
                    'first_name'       => $data['first_name'],
                    'last_name'        => $data['last_name'],
                    'effective_date'   => $data['effective_date'],
                    'branch'           => $data['branch'],
                    'department'       => $data['department'],
                    'employeeID'       => $data['employeeID'],
                    'address'          => $data['address'],
                    'city'             => $data['city'],
                    'state'            => $data['state'],
                    'zip'              => $data['zip'],
                    'telephone'        => $data['telephone']
                    // 'ssn'              => decryptthis($data['ssn'], $secretkey)
               );

                // New Hire Section Array
                $newhireList= array(
                    'Hire_Reason'               => $data['Hire_Reason'],
                    'replacement_for'           => $data['replacement_for'],
                    'employment_Status'         => $data['employment_Status'],
                    'drivers_License'           => decryptthis($data['drivers_License'], $secretkey),
                    'state_Issued'              => $data['state_Issued'],
                    'date_of_Birth'             => decryptthis($data['date_of_Birth'], $secretkey),
                    'gender'                    => $data['gender'],
                    'ethnic_Code'               => $data['ethnic_Code'],
                    'marital_Status'            => $data['marital_Status'],
                    'job_Title'                 => $data['job_Title'],
                    'starting_Rate'             => decryptthis($data['starting_Rate'], $secretkey),
                    'per'                       => $data['per'],
                    'bonus_Commission_Plan'     => $data['bonus_Commission_Plan'],
                    'bonus_Level'               => $data['bonus_Level'],
                    'Training_Needed'           => $data['Training_Needed'],
                    'Technician_shift'          => $data['Technician_shift'] ?? '',
                    'Alarm_Code'                => $data['Alarm_Code'],
                    'Need_Workstation'          => $data['Need_Workstation'],
                    // 'other'                     => $data['other'],
                    'New_Hire_Remarks'          => $data['New_Hire_Remarks']
                );

                // Change Section Array
                // $changeList= array('Job_Title_From', 'Job_Title_To', 'Pay_From', 'Pay_From_Per', 'Pay_To', 'Pay_To_Per', 'From_Branch', 'To_Branch', 'From_Department', 'To_Department', 'From_Employee_Status', 'To_Employee_Status', 'Change_Remarks');
                $changeList= array(
                    'Job_Title_From'            => $data['Job_Title_From'],
                    'Job_Title_To'              => $data['Job_Title_To'],
                    'Pay_From'                  => decryptthis($data['Pay_From'], $secretkey),
                    'Pay_From_Per'              => $data['Pay_From_Per'],
                    'Pay_To'                    => decryptthis($data['Pay_To'], $secretkey),
                    'Pay_To_Per'                => $data['Pay_To_Per'],
                    'From_Branch'               => $data['From_Branch'],
                    'To_Branch'                 => $data['To_Branch'],
                    'From_Department'           => $data['From_Department'],
                    'To_Department'             => $data['To_Department'],
                    'From_Employee_Status'      => $data['From_Employee_Status'],
                    'To_Employee_Status'        => $data['To_Employee_Status'],
                    'Change_Remarks'            => $data['Change_Remarks']
              );


                // Separation Section Array
                // $separationList=array('Hire_Date', 'Last_Day_Worked', 'Separation_Date', 'Separation_Type', 'Separation_Reason', 'Eligible_to_Rehire', 'forward_emails', 'forwarding_to_employee_name', 'Separation_Remarks');
                $separationList=array(
                    'Hire_Date'                     => $data['Hire_Date'],
                    'Last_Day_Worked'               => $data['Last_Day_Worked'],
                    'Separation_Date'               => $data['Separation_Date'],
                    'Separation_Type'               => $data['Separation_Type'],
                    'Separation_Reason'             => $data['Separation_Reason'],
                    'Eligible_to_Rehire'            => $data['Eligible_to_Rehire'],
                    'forward_emails'                => $data['forward_emails'],
                    'forwarding_to_employee_name'   => $data['forwarding_to_employee_name'],
                    'Separation_Remarks'            => $data['Separation_Remarks']
              );


                 $email_message =  '<table rules="all" style="border-color: #666; font-family: Montserrat-Regular; font-size:14px; border-radius:7px 7px 0 0" cellpadding="10">';
                 $email_message .= '<tr style="background: #fff"><td colspan="2" align="center"><img src="http://www.selectransportation.com/helpdesk/Images/STR-LOGO1.png"></td></tr>';
                 $email_message .= '<tr style="background: #000000; color:#fff; border-radius: 8px 8px 0 0"><td colspan="2" align="center"><h3>' . strip_tags($subject) .'</h3></td></tr>';


      foreach ($personnelNoticeList as $key => $personnelNoticeListValues) {

      // echo "$key: $personnelNoticeListValues\n";


                  if(isset($data[$key]) && $data[$key] != ''){

                      // Adds alternate colors to the table rows
                      $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
                      // $colorOne = '#ffffff';
                      // $colorTwo = '#f3f3f3';
                      // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
                      // $rowCount++;

                      // email Body
                      $email_message .= '<tr bgcolor="' . $colour . '">';
                      $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
                       // $email_message .= '<td>'. wordwrap(htmlspecialchars($row[$key], ENT_QUOTES),75, "<br />\n") .'</td>';
                      // $email_message .= '<td>'. wordwrap(htmlspecialchars((decryptthis($row[$key], $secretkey)), ENT_QUOTES),75, "<br />\n") .'</td>';
                      $email_message .= '<td>'. wordwrap(htmlspecialchars($personnelNoticeListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
                      $email_message .= '</tr>';
                      $c++;

                    }
                 }


               $email_message .= '<tr style="background: #000000; color:#fff;"><td colspan="2" align="center" id="NewHireEmailTitle"><h3>'. $data['FormType'] . '</h3></td></tr>';
               foreach ($newhireList as $key => $newhireListValues) {
                     if(isset($data[$key]) && $data[$key] != ''){

                       // Adds alternate colors to the table rows
                       $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
                       // $colorOne = '#ffffff';
                       // $colorTwo = '#f3f3f3';
                       // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
                       // $rowCount++;

                       // email Body
                       $email_message .= '<tr bgcolor="' . $colour . '">';
                       $email_message .= '<td><strong>'. ucwords(str_replace("_", " ", $key))  . '</strong></td>';
                       $email_message .= '<td style="text-align:justify; text-justify: distribute; text-align-last: left;">'. wordwrap(htmlspecialchars($newhireListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
                       $email_message .= '</tr>';
                       $c++;
                     }
                  }

              // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="ChangeEmailTitle"><h3>'. $ChangeEmailTitle . '</h3></td></tr>';
              foreach ($changeList as $key => $changeListValues) {
                        if(isset($data[$key]) && $data[$key] != ''){

      echo "$key: $changeListValues\n <br />";

                          // Adds alternate colors to the table rows
                          $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
                          // $colorOne = '#ffffff';
                          // $colorTwo = '#f3f3f3';
                          // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
                          // $rowCount++;

                          // email Body
                          $email_message .= '<tr bgcolor="' . $colour . '">';
                          $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
                          $email_message .= '<td style="text-align:justify; text-justify: distribute; text-align-last: left;">'. wordwrap(htmlspecialchars($changeListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
                          $email_message .= '</tr>';
                          $c++;
                     }
                 }

             // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="SeparationEmailTitle"><h3>'. $SeparationEmailTitle . '</h3></td></tr>';
             foreach ($separationList as $key => $separationListValues) {
                     if(isset($data[$key]) && $data[$key] != ''){

                         // Adds alternate colors to the table rows
                         $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
                         // $colorOne = '#ffffff';
                         // $colorTwo = '#f3f3f3';
                         // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
                         // $rowCount++;

                         // email Body
                         $email_message .= '<tr bgcolor="' . $colour . '">';
                         $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
                         $email_message .= '<td style="text-align:justify; text-justify: distribute; text-align-last: left;">'. wordwrap(htmlspecialchars($separationListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
                         $email_message .= '</tr>';
                         $c++;
                     }
                 }


                     // echo "no image";
                  //    $email_message .= '<tr>';
                  // if ($data['Attachment'] === ""){
                  //    $email_message .= '<td  style=" display: none;">
                  //     <h5>NO ATTACHMENTS</h5>
                  //    </td>';
                  // }else{
                  //  $email_message .= '<td colspan="2" width="100%" height="30"  style="background-color: #0047AB; text-align:center; color: #ffffff; display: block;">
                  //  <a href="http://webdev.str.com/wordpress/helpdesk/uploads/'. $data['Attachment'] . '"  style="font-size:15px; font-weight: bold; font-family: Helvetica, Arial, sans-serif; text-decoration: none; line-height:40px; width:100%; display:inline-block"><span style="color: #FFFFFF">ATTACHMENT</span></a>
                  //  </td>';
                  // }
                  //
                  //  $email_message .= '</tr>';

                   $email_message .= '<tr bgcolor="#ccc">';
                   $email_message .= '<td colspan="2" width="100%" height="30" bgcolor="#1F7F4C" style="text-align:center; -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; color: #ffffff; display: block;">
                   <a href="https://helpdesk.selectransportation.com/approval.php?PAN_ID=' . base64_encode($PAN_ID) .  '&personnelOnly=' . base64_encode($personnelOnly) .'" style="font-size:15px; font-weight: bold; font-family: Helvetica, Arial, sans-serif; text-decoration: none; line-height:40px; width:100%; display:inline-block"><span style="color: #FFFFFF">APPROVE/REJECT</span></a>
                   </td>';
                   $email_message .= '</tr>';

                   // $email_message .= '</tr>';
                   $email_message .= "<tr style='background: #000000; color:#fff; border-radius: 8px 8px 0 0'><td colspan='2' align='center'>Copyright &copy STR HelpDesk. All Rights Reserved.</td></tr>";
                   $email_message .= "</table>";
                   $email_message .= "</body></html>";


                   // Header for sender info
                   $headers = "From: $fromName"." <".$from.">";

                   // if(!empty($uploadedFile) && file_exists($uploadedFile)){

                   //     // Boundary
                       $semi_rand = md5(time());
                       $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
                   //
                   //     // Headers for attachment
                       $headers .= "\nMIME-Version: 1.0\n" . "Content-Type: multipart/mixed;\n" . " boundary=\"{$mime_boundary}\"";
                   //
                   //     // Multipart boundary
                       $message = "--{$mime_boundary}\n" . "Content-Type: text/html; charset=\"UTF-8\"\n" .
                       "Content-Transfer-Encoding: 7bit\n\n" . $email_message . "\n\n";

                       $message .= "--{$mime_boundary}--";
                       $returnpath = "-f" . $from;

                       // Send email
                       // $mail = mail($toHREmail, $subject, $message, $headers, $returnpath);

                       // Delete attachment file from the server
                       //     @unlink($uploadedFile);
                   // }else{
                       // Set content-type header for sending HTML email
                       $headers .= "\r\n". "MIME-Version: 1.0";
                       $headers .= "\r\n". "Content-type:text/html;charset=UTF-8";
                       // $headers .= "\r\n"."From: saquib.patwa@strhouston.com" . "\r\n" ."CC: saquib.patwa@strhouston.com";
                       // $headers .= "\r\n". "cc: saquib.test@houstonfreightliner.com"; #Your BCC Mail List
                       // $headers .= "\r\n". "Cc: " . $from .  "\r\n"; #Your BCC Mail List
                        // $headers .= "\r\n". "Bcc: saquib.test@strhouston.com"; #Your BCC Mail List

                        // $headers.="Bcc: ".implode(", ",$from_email)."\r\n";  // blind carbon copy all emails
                        // $headers .= "Cc: " . implode(", ", ['$from', $from_email]) .  "\r\n"; #Your BCC Mail List

                      // Send email
                       // $mail = mail($to, $subject, $email_message, $headers);
                        // $mail = mail($to, $subject, $email_message, $headers, $returnpath);
                   // }



















                // Send the email
                if (mail($to, $subject, $email_message, $headers)) {
                    echo "Email sent successfully";
                } else {
                    echo "Failed to send email";
                }
            } else {
                // No record found with the given PAN_ID
                echo "No record found with that PAN_ID";
            }

            // Close the statement
            $stmt->close();
        } else {
            // SQL statement preparation failed
            echo "SQL Error: " . $conn->error;
        }
    } else {
        // Either 'id' or 'personnelOnly' is missing from the POST request
        echo "Invalid request: Missing 'id' or 'personnelOnly'";
    }
} else {
    // Request method is not POST
    echo "Invalid request method. Expected POST.";
}

// Close the database connection
$conn->close();


?>
